Zimbra Upload Component
========================
Zimbra Upload provides wrapper for the zimbra upload client.

## Basic usage of `zimbra` upload client
```php
<?php

// This file is generated by Composer
require_once 'vendor/autoload.php';

$request = new \Zimbra\Upload\Request($requestId, [$file]);
$client = new \Zimbra\Upload\Client('https://localhost/service/upload', $authToken);
$attachments = $client->upload($request);
```
`$authToken` is user authentication token, it can obtain from zimbra acount api.
```php
<?php
$account = new \Zimbra\Struct\AccountSelector(\Zimbra\Enum\AccountBy::NAME(), 'username');
$api = \Zimbra\Account\AccountFactory::instance('https://localhost/service/soap');
$auth = $api->auth($account, 'password');
$authToken = $auth->authToken;
```

## Installation

This package can be installed easily using `Composer <http://getcomposer.org>`.
Simply add the following to the composer.json file at the root of your project:

```javascript
{
    "require": {
        "zimbra-api/upload": "*"
    }
}
```
Then install your dependencies using ``composer.phar install``.
