<?php
use WHMCS\Database\Capsule;
include_once dirname(__FILE__) . '/api/vendor/autoload.php';

function zimbraSingle_MetaData() {
    return array(
            'DisplayName' => 'Zimbra Single Mailbox Provisioning',
            'APIVersion' => '1.2',
			'DefaultNonSSLPort' => '7071',
			'DefaultSSLPort' => '7071',
            'RequiresServer' => true,
            'ServiceSingleSignOnLabel' => 'Login to Zimbra',
            'AdminSingleSignOnLabel' => 'Login to Zimbra Admin'
    );
}
/**
 */
function zimbraSingleGetAccess() {
	$accessData = array ('URL' => '', 'adminUser' => '', 'adminPass' => '');
    $servers = Capsule::table('tblservers')
                         ->select('ipaddress', 'username', 'password')
                         ->where('id', '=', $_SESSION[CreatedServerId])
                         ->get();
    $accessData['URL'] = 'https://' . $servers[0]->ipaddress . ':' . zimbraSingle_MetaData()['DefaultSSLPort'] . '/service/admin/soap';
    $accessData['adminUser'] = $servers[0]->username;
    $adminPassCrypt = $servers[0]->password;
    $adminPassDecrypt = localAPI('DecryptPassword', array('password2' => $adminPassCrypt ));
    if ($adminPassDecrypt['result'] == 'success') {
        $accessData['adminPass'] = $adminPassDecrypt['password'];
    }
    return $accessData;
}

/**
 * List all zimbra acocunts by the given domain name
 * 
 * @param	The name of the domain to list the accounts for
 * @return 	array of strings containing all account email addresses (primary account names) for this domain
 */ 
function zimbraSingleGetAllAccountNamesFor($domainName) {
    $accessData = zimbraSingleGetAccess();
    $returnAccounts = array();

    $api = \Zimbra\Admin\AdminFactory::instance($accessData['URL']);

	try {
		if ($api->auth($accessData['adminUser'], $accessData['adminPass']) != true) {
		    logModuleCall(
        		'zimbrasingle',
        		__FUNCTION__,
        		$params,
        		"Connection to " . $URL . " failed: Cannot login",
        		""
    		    );
		    return array(
		        'success' => false,
				'error' => "Login to " . $URL . " Host failed",
		    );
		} else {
		    logModuleCall(
        		'zimbrasingle',
        		__FUNCTION__,
        		$params,
        		"Connection to " . $URL . " successful",
        		""
    		    );
    $domain = new \Zimbra\Admin\Struct\DomainSelector(\Zimbra\Enum\DomainBy::NAME(),$domainName);
    $accounts = $api->getAllAccounts(null,$domain);
    foreach ($accounts->account as $account) {
	array_push($returnAccounts,$account->name);
    }
return $returnAccounts;
		}
	} catch (Exception $exe) {
		logModuleCall(
			'zimbrasingle',
			__FUNCTION__,
			$params,
			$exe->getMessage(),
			$exe->getTraceAsString()
		);
		return array(
			'success' => false,
			'error' => "Login to " . $URL . " Host failed, the error was: " . $exe->getMessage(),
		);
	}
}

/**
 * Checks if a given email address in the given domain already exists
 * 
 * @param  $emailNameOnly 	The name before the @-sign only
 * @param  $domainName		The domain to search for existance of the email account
 * @return true if such an account was found or false if not
 */
function zimbraSingleDoesEMailExist($emailNameOnly,$domainName) {
    $fullName = $emailNameOnly . "@" . $domainName;
    $accounts = zimbraSingleGetAllAccountNamesFor($domainName);
    foreach ($accounts as $account) {
		if(strcmp($fullName, $account) == 0) {
			return true;
		}
    }
    return false;
}

/**
 * Creates a new zimbra account
 *
 * @param	userName, the full username inclusive domain
 * @param	password, the password of the user
 * @param	givenName, the given name of the user
 * @param 	surName, the surname of the user
 *
 * @return	true if successful
 */
function zimbraSingleCreateAccount($userName,$password,$givenName,$surName) {
    $zimbraURL = buildZimbraURL();
    $adminUser = getZimbraAdminUser();
    $adminPassword = getZimbraAdminPassword();
    
    $attrs = array();
    $attrs["givenName"] = $givenName;
    $attrs["sn"] = $surName;
    $attrs["displayName"] = $givenName . " " . $surName;
    
    
    $api = \Zimbra\Admin\AdminFactory::instance($zimbraURL . '/service/admin/soap');
    $api->auth($adminUser, $adminPassword);
    
    $api->createAccout($userName,$password,$attrs);
}
function zimbraSingleTestFunction() {
	return 'blubb';
}

?>
