<?php

use WHMCS\Database\Capsule;

include_once dirname(__FILE__) . '/api/vendor/autoload.php';

function zimbraSingle_MetaData()
{
    return array(
        'DisplayName' => 'Zimbra Single Mailbox Provisioning',
        'APIVersion' => '1.2',
        'DefaultNonSSLPort' => '7071',
        'DefaultSSLPort' => '7071',
        'RequiresServer' => true,
        'ServiceSingleSignOnLabel' => 'Login to Zimbra',
        'AdminSingleSignOnLabel' => 'Login to Zimbra Admin'
    );
}
/**
 */
function zimbraSingleGetAccess()
{
    $accessData = array('URL' => '', 'adminUser' => '', 'adminPass' => '');
    $servers = Capsule::table('tblservers')
        ->select('ipaddress', 'username', 'password')
        ->where('id', '=', $_SESSION[CreatedServerId])
        ->get();
    $accessData['URL'] = 'https://' . $servers[0]->ipaddress . ':' . zimbraSingle_MetaData()['DefaultSSLPort'] . '/service/admin/soap';
    $accessData['adminUser'] = $servers[0]->username;
    $adminPassCrypt = $servers[0]->password;
    $adminPassDecrypt = localAPI('DecryptPassword', array('password2' => $adminPassCrypt));
    if ($adminPassDecrypt['result'] == 'success') {
        $accessData['adminPass'] = $adminPassDecrypt['password'];
    }
    return $accessData;
}

/**
 * List all zimbra acocunts by the given domain name
 *
 * @param       The name of the domain to list the accounts for
 * @return      array of strings containing all account email addresses (primary account names) for this domain
 */
function zimbraSingleGetAllAccountNamesFor($domainName)
{
    $accessData = zimbraSingleGetAccess();
    $returnAccounts = array();

    $api = \Zimbra\Admin\AdminFactory::instance($accessData['URL']);

    try {
        if ($api->auth($accessData['adminUser'], $accessData['adminPass']) != true) {
            logModuleCall(
                'zimbrasingle',
                __FUNCTION__,
                $params,
                "Connection to " . $accessData['URL'] . " failed: Cannot login",
                ""
            );
            return array(
                'success' => false,
                'error' => "Login to " . $accessData['URL'] . " Host failed",
            );
        } else {
            logModuleCall(
                'zimbrasingle',
                __FUNCTION__,
                $params,
                "Connection to " . $accessData['URL'] . " successful",
                ""
            );
            $domain = new \Zimbra\Admin\Struct\DomainSelector(\Zimbra\Enum\DomainBy::NAME(), $domainName);
            $accounts = $api->getAllAccounts(null, $domain);
            foreach ($accounts->account as $account) {
                array_push($returnAccounts, $account->name);
            }
            return $returnAccounts;
        }
    } catch (Exception $exe) {
        logModuleCall(
            'zimbrasingle',
            __FUNCTION__,
            $params,
            $exe->getMessage(),
            $exe->getTraceAsString()
        );
        return array(
            'success' => false,
            'error' => "Login to " . $accessData['URL'] . " Host failed, the error was: " . $exe->getMessage(),
        );
    }
}

/**
 * Checks if a given email address in the given domain already exists
 *
 * @param  $emailNameOnly       The name before the @-sign only
 * @param  $domainName          The domain to search for existance of the email account
 * @return true if such an account was found or false if not
 */
function zimbraSingleDoesEMailExist($emailNameOnly, $domainName)
{
    $fullName = $emailNameOnly . "@" . $domainName;
    $accounts = zimbraSingleGetAllAccountNamesFor($domainName);
    if (array_key_exists('error', $accounts)) {
        return "E-Mail Adresse konnte nicht verifiziert werden.";
    }
    foreach ($accounts as $account) {
        if (strcmp($fullName, $account) == 0) {
            return true;
        }
    }
    return false;
}

/**
*/
function zimbraSingleCreateAccount($userData)
{
    $accessData = zimbraSingleGetAccess();
    $attrs = array();
    $attrs["givenName"] = $userData["givenname"];
    $attrs["sn"] = $userData["sn"];
    $attrs["displayName"] = $attrs["givenName"] . " " . $attrs["sn"];
    $passDecrypt = localAPI('DecryptPassword', array('password2' => $userData['password']));
    if ($passDecrypt['result'] == 'success') {
        $userData['password'] = $passDecrypt['password'];
    }
    $mailAddress = $userData['username'] . '@' . $userData['maildomain'];
    $api = \Zimbra\Admin\AdminFactory::instance($accessData['URL']);
    $api->auth($accessData['adminUser'], $accessData['adminPass']);
//    $response = $api->createAccount("$mailAddress", "$userData['password']", "$attrs");
try {
 $api->createAccount('test3@thurdata.local', 'test123i-A');
} catch (Exception $exe) {
 $message=$exe->getMessage();
 $trace=$exe->getTraceAsString();
}
    ob_start();
    echo $mailAddress;
    print_r($attrs);
    print_r($userData);
    print_r($accessData);
    print_r($message);
    print_r($trace);
    file_put_contents('debug.txt', ob_get_contents());
    ob_end_clean();

    return $response;
}

function zimbraSingle_checkPassword($pwd)
{
    if (strlen($pwd) < 9) {
        return "Das das Passwort ist zu kurz. Es werden mind. 9 Zeichen benötigt";
    }

    if (!preg_match("#[0-9]+#", $pwd)) {
        return "Das Passwort muss mindestens eine Zahl enthalten";
    }

    if (!preg_match("#[A-Z]+#", $pwd)) {
        return "Das Passwort muss mindestens einen Grossbuchstaben (A-Z) enthalten";
    }

    if (!preg_match("#[a-z]+#", $pwd)) {
        return "Das Passwort muss mindestens einen Kleinbuchstaben (a-z) enthalten";
    }

    if (!preg_match("#[^\w]+#", $pwd)) {
        return "Das Passwort muss mindestens ein Sonderzeichen (.,-:=) enthalten";
    }
    return null;
}

function zimbraSingleTestFunction()
{
    return 'blubb';
}

