Zimbra Account Component
========================
Zimbra Account provides wrapper for the zimbra account client.

## Basic usage of `zimbra` account client
```php
<?php

// This file is generated by Composer
require_once 'vendor/autoload.php';

$account = new \Zimbra\Struct\AccountSelector(\Zimbra\Enum\AccountBy::NAME(), 'username');
$api = \Zimbra\Account\AccountFactory::instance('https://localhost/service/soap');
$api->auth($account, 'password');
$accountInfo = $api->getAccountInfo($account);
```
From `$api` object, you can access to all zimbra account api.


## Installation

This package can be installed easily using `Composer <http://getcomposer.org>`.
Simply add the following to the composer.json file at the root of your project:

```javascript
{
    "require": {
        "zimbra-api/account": "*"
    }
}
```
Then install your dependencies using ``composer.phar install``.
