Zimbra Admin Component
======================
Zimbra Admin provides wrapper for the zimbra admin client.

## Basic usage of `zimbra` admin client
```php
<?php

// This file is generated by Composer
require_once 'vendor/autoload.php';

$api = \Zimbra\Admin\AdminFactory::instance('https://localhost:7071/service/admin/soap');
$api->auth('username', 'password');
$account = new \Zimbra\Struct\AccountSelector(\Zimbra\Enum\AccountBy::NAME(), 'username');
$accountInfo = $api->getAccountInfo($account);
```
From `$api` object, you can access to all zimbra admin api.


## Installation

This package can be installed easily using `Composer <http://getcomposer.org>`.
Simply add the following to the composer.json file at the root of your project:

```javascript
{
    "require": {
        "zimbra-api/admin": "*"
    }
}
```
Then install your dependencies using ``composer.phar install``.
