<?php
/**
 * WHMCS Zimbra Provisioning Module
 *
 * Provisioning for private user accounts on the Zimbra Server
 *
 * @see https://www.zimbra.com
 * @copyright Copyright (c) Thurdata GmbH 2020
 * @license GPL
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}
require_once dirname(__FILE__) . '/zimbraSingle.inc';

print_r($params);


function zimbraSingle_AdminServicesTabFieldsSave($params) {
	global $sf, $dbc;
	$zimbraSingleURL   = zimbraSingleBuildURL($params);
	$apiuser           = $params['serverusername'];
	$apipass           = $params['serverpassword'];
	$api = \Zimbra\Admin\AdminFactory::instance($zimbraSingleURL . '/service/admin/soap');
	try {
		if ($api->auth($apiuser, $apipass) != true) {
		    return "Login to " . $zimbraSingleURL . " Host failed.\n";
		}
	} catch (Exception $exe) {
	}
}

function zimbraSingle_TestConnection($params) {
    $URL = 'https://' .  $params['serverip'] . ':' . zimbraSingle_MetaData()['DefaultSSLPort'] . '/service/admin/soap';
	$apiuser           = $params['serverusername'];
	$apipass           = $params['serverpassword'];
	$api = \Zimbra\Admin\AdminFactory::instance($URL);
	
	error_log("Connecting to: " . $URL . " with " . $apiuser . " and " . $apipass);
	
	try {
		if ($api->auth($apiuser, $apipass) != true) {
		    logModuleCall(
        		'zimbrasingle',
        		__FUNCTION__,
        		$params,
        		"Connection test to " . $URL . " failed: Cannot login",
        		""
    		    );
		    return array(
		        'success' => false,
				'error' => "Login to " . $URL . " Host failed",
		    );
		} else {
		    logModuleCall(
        		'zimbrasingle',
        		__FUNCTION__,
        		$params,
        		"Connection Test to " . $URL . " successful",
        		""
    		    );
		    return array(
		        'success' => true,
				'error' => '',
		    );
		}
	} catch (Exception $exe) {
		logModuleCall(
			'zimbrasingle',
			__FUNCTION__,
			$params,
			$exe->getMessage(),
			$exe->getTraceAsString()
		);
		return array(
			'success' => false,
			'error' => "Login to " . $URL . " Host failed, the error was: " . $exe->getMessage(),
		);
	}
}

function zimbraSingle_UsageUpdate($params) {
}


function zimbraSingle_ClientArea($params) {

   // error_log(print_r($params,true));
#   error_log("CLIENT-AREA");
#   $zimbraSingleURL   = buildzimbraSingleURL($params);
#   $user = $params['username'];

#   $result0 = select_query("tblconfiguration","value" , array('setting' => 'Language'));
#   $data0 = mysql_fetch_array($result0);
#   $lla = ($_SESSION['Language']) ? trim($_SESSION['Language']) : strtolower($data0[0]);

#   $slang = array();
#   include_once dirname(__FILE__).'/lang/'.$lla.'.php';

#   return array(
#    'templatefile' => 'clientside',
#    'vars' => array_merge(array(
#      'url' => $seafileURL,
#      'user' => $user,
#      'mobile1' => $app,
#      'mobile2' => $google,
#      'drivewin' => $driveWin,
#      'winclient' => $winClient,
#      'macclient' => $macClient,
#      'drivemac' => $driveMac,
#      'linClient' => $linClient,
#    ), $slang, $params),
#  );
}

function zimbraSingle_ClientAreaCustomButtonArray() {
    $buttonarray = array(
	 "Reset Password" => "ClientPassword",
    );
    return $buttonarray;
}


function zimbraSingle_ChangePassword($params) { 
#	if (strcmp($params['status'],"Active") !== 0) {
#	    return "Der Dienst ist gesperrt, das Passwort kann daher nicht geändert werden";
#	}
#	$loginPassword = $params["customfields"]["Passwort"];
#	$checkPassword = checkPassword($loginPassword);
#	if ($checkPassword != null) {
#	    return $checkPassword;
#	}
#	$fieldID = getCustomFieldIDFor($params,"Passwort");
#	
#	$seafileURL   = buildSeafileURL($params);
#	$apiuser      = getSeafileAdminUser($params);
#	$apipass      = getSeafileAdminPassword($params);
#	
#	$seafileAPI = new SeafileAPI($seafileURL,$apiuser,$apipass);
#	if ($seafileAPI->login() != true) {
#   	    logModuleCall(
#        	'seafile',
#        	__FUNCTION__,
#        	$params,
#        	"Cannot login to " . $seafileURL,
#        	""
#    	    );
#	    return "Login to " . $seafileURL . " fehlgeschlagen. Bitte den Administrator informieren.\n";
#	}
#
#	$userAccount = $seafileAPI->getAccountByEMail($params['username']);
#	if ($userAccount != null) {
#	    $userAccount->password = $loginPassword;
#	    try {
#		$result = $seafileAPI->updateAccount($userAccount);
#		if ($result != true) {
#		    logModuleCall(
#       		'seafile',
#				__FUNCTION__,
#        		$params,
#        		"Cannot change password for " . $userAccount->email . ": Unknown error",
#        		""
#    		    );
#		    return "Das Passwort konnte nicht aktualisiert werden. Unbekannter Fehler.";
#		} else {
#		    update_query(   "tblcustomfieldsvalues",array(   "value" => $loginPassword,"updated_at"=> "now()", ),array("id" => $fieldID)   );
#		    logModuleCall(
#        		'seafile',
#        		__FUNCTION__,
#        		$params,
#        		"Changed password for " . $userAccount->email,
#        		""
#    		    );
#		    return 'success';
#		}
#	    } catch (Exception $exe) {
#	        logModuleCall(
#        		'seafile',
#        		__FUNCTION__,
#        		$params,
#        		"Cannot change password for " . $userAccount->email . ", the error was " . $exe->getMessage(),
#        		$exe->getTraceAsString()
#    		    );
#		return "Fehler beim Update des Passworts, der Fehler war: " . $exe->getMessage();
#	    }
#	} else {
#	    logModuleCall(
#        	'seafile',
#        	__FUNCTION__,
#        	$params,
#        	"Changed password for " . $userAccount->email,
#    		""
#    	    );
#	    return "Konnte den Account " . $params['username'] . " auf dem Server nicht finden";
#	}
}



function zimbraSingle_ClientPassword($params) { 
/*	if (strcmp($params['status'],"Active") !== 0) {
	    return "Der Dienst ist gesperrt, das Passwort kann daher nicht geändert werden";
	}
	$password1 = $_POST['password1'];
	$password2 = $_POST['password2'];

	if (empty($password1) == true || empty($password2) == true) {
	    return "Bitte beide Passwörter zuerst ausfüllen";
	}
	if (strcmp($password1,$password2) !== 0) {
	    return "Die Passwörter stimmen nicht überein";
	}
	
	$checkPassword = checkPassword($password1);
	if ($checkPassword != null) {
	    return $checkPassword;
	}
	$fieldID = getCustomFieldIDFor($params,"Passwort");	
	
	$seafileURL   = buildSeafileURL($params);
	$apiuser      = getSeafileAdminUser($params);
	$apipass      = getSeafileAdminPassword($params);
	
	$seafileAPI = new SeafileAPI($seafileURL,$apiuser,$apipass);
	if ($seafileAPI->login() != true) {
	    logModuleCall(
        	'seafile',
        	__FUNCTION__,
        	$params,
        	"Cannot login to " . $seafileURL,
        	""
    	    );
	    return "Login to " . $seafileURL . " fehlgeschlagen. Bitte den Administrator informieren.\n";
	}

	$userAccount = $seafileAPI->getAccountByEMail($params['username']);
	if ($userAccount != null) {
	    $userAccount->password = $password1;
	    try {
		$result = $seafileAPI->updateAccount($userAccount);
		if ($result != true) {
		    return "Das Passwort konnte nicht aktualisiert werden. Unbekannter Fehler.";
		} else {
		    update_query(   "tblcustomfieldsvalues",array(   "value" => $password1,"updated_at"=> "now()", ),array("id" => $fieldID)   );
		    return 'success';
		}
	    } catch (Exception $exe) {
	    	    logModuleCall(
        		'seafile',
        		__FUNCTION__,
        		$params,
        		"Cannot change password for " . $userAccount->email . ", the error was " . $exe->getMessage(),
        		$exe->getTraceAsString()
    		    );
		return "Fehler beim Update des Passworts, der Fehler war: " . $exe->getMessage();
	    }
	} else {
	    logModuleCall(
        	'seafile',
        	__FUNCTION__,
        	$params,
    		"Cannot find the Account " . $params['username'],
        	""
    	    );
	    return "Konnte den Account " . $params['username'] . " nicht finden";
	} */
}


function zimbraSingle_CreateAccount($params) {
/*	global $sf, $errored, $dbc;
	
	$seafileURL   = buildSeafileURL($params);
	$apiuser      = getSeafileAdminUser($params);
	$apipass      = getSeafileAdminPassword($params);
	
	$seaserver     = $params['serverid'];
	$firstName     = $params["clientsdetails"]["firstname"];
	$lastName      = $params["clientsdetails"]["lastname"];
	$email	       = $params["clientsdetails"]["email"];
	$loginEMail    = $params["customfields"]["Login-E-mail"];
	$loginPassword = $params["customfields"]["Passwort"];
	$addonQuota    = $params["configoptions"]["Zus\xc3\xa4tzliche Gigabyte Speicherplatz"];
	$phonenum      = $params["clientsdetails"]["phonenumber"];
	$quota         = ($params['configoptions']["Quota"]) ? $params['configoptions']["Quota"] : $params['configoption4'];

	$ssquery = select_query("tblhosting", "domainstatus", array("id" => $params['serviceid']));
	$ssresult = mysql_fetch_array($ssquery);
	
	if($loginEMail) {   update_query("tblhosting", array("username" => $loginEMail), array("id" => $params["serviceid"]) );         }
	if($loginPassword) {   update_query("tblhosting", array("password" => $loginPassword), array("id" => $params["serviceid"]) );   }

	$seafileAPI = new SeafileAPI($seafileURL,$apiuser,$apipass);
	if ($seafileAPI->login() != true) {
	    logModuleCall(
        	'seafile',
        	__FUNCTION__,
        	$params,
        	"Cannot login to " . $seafileURL,
        	""
    	    );
	    return "Login to " . $seafileURL . " Host failed.\n";
	}

	//error_log("CHECK EMAIL: " . $loginEMail . " / " . $loginPassword . " #### " . $quota . " + " . $addonQuota);
	$existingAccountType = $seafileAPI->getAccountByEMail($loginEMail);

	if($ssresult[0] == 'Active') {
	    if (  is_null($existingAccountType) != true ) {
		return "Ein solcher Account existiert bereits. Für die Neuerstellung bitte zuerst Terminieren";
	    }
	} else {
	    if (  is_null($existingAccountType) != true ) {
		return "Es gibt auf dem Seafile-Server bereits einen Account mit dieser E-Mail-Adresse, bitte vorher prüfen";
	    }
	}
	$accountQuota = ($quota + $addonQuota) * 1000;

        $newAccount = new Seafile\Client\Type\Account();
    	    $newAccount->email = $loginEMail;
	    $newAccount->name = $firstName . " " . $lastName;
	    $newAccount->isActive = 1;
	    $newAccount->isStaff = 0;
	    $newAccount->password = $loginPassword;
	    $newAccount->note = "Account created from WHCMS";
	    $newAccount->quotaTotal = $accountQuota;



	error_log("Seafile: Create new Account: " . $loginEMail . " (" . $firstName . " " . $lastName . ") with Quota (" . $quota . " / " . $addonQuota . ") " . $accountQuota );
    	$result = false;
    	try {
	    $result = $seafileAPI->createAccount($newAccount);
	} catch (Exception $exe) {
	    error_log($exe->getMessage());
	    error_log($exe->getTraceAsString());
	    logModuleCall(
        	'seafile',
    		__FUNCTION__,
        	$params,
    		"Cannot create account: "  . $loginEMail . ", the error was " . $exe->getMessage(),
        	$exe->getTraceAsString()
    	    );
	    return "Fehler beim Erstellen des Accounts, der Fehler war: " . $exe->getMessage();
	}
	if ($result != true) {
	    error_log("Error while creating the new account " . $loginEMail . ", the result is: " . $result);
	    logModuleCall(
        	'seafile',
        	__FUNCTION__,
        	$params,
    		"Cannot create the account " . $loginEMail . ": Unknown error",
    		$result
    	    );
	    return "Fehler beim Erstellen des Accounts: Unbekannter Fehler";
	} else {
	    logModuleCall(
        	'seafile',
        	__FUNCTION__,
        	$params,
    		"Created user: " . $loginEMail,
    		$result
    	   );
	   return 'success';
	} */
}

function zimbraSingle_SuspendAccount($params) {
/*	$seafileURL   = buildSeafileURL($params);
	$apiuser      = getSeafileAdminUser($params);
	$apipass      = getSeafileAdminPassword($params);

	$seafileAPI = new SeafileAPI($seafileURL,$apiuser,$apipass);
	if ($seafileAPI->login() != true) {
	    logModuleCall(
        	'seafile',
        	__FUNCTION__,
        	$params,
        	"Cannot login to " . $seafileURL,
        	""
    	    );
	    return "Login to ".$params['serverhostname']." Host failed.\n";
	}
	
	if ($seafileAPI->disableUser($params['username']) != true) {
	    logModuleCall(
    		'seafile',
    		__FUNCTION__,
    		$params,
    		"Cannot disable/suspend user aaccount " . $params['username'] . "Unknown error",    	    
    		""
    	    );
	    return "Error while suspend Account: " . $params['username'];
	} else {
	    logModuleCall(
    		'seafile',
    		__FUNCTION__,
    		$params,
    		"Disabled/suspended user aaccount " . $params['username'],
    		""
    	    );

	    return 'success';
	} */
}


function zimbraSingle_UnsuspendAccount($params) {
/*	$seafileURL   = buildSeafileURL($params);
	$apiuser      = getSeafileAdminUser($params);
	$apipass      = getSeafileAdminPassword($params);

	$seafileAPI = new SeafileAPI($seafileURL,$apiuser,$apipass);
	if ($seafileAPI->login() != true) {
	    logModuleCall(
        	'seafile',
        	__FUNCTION__,
        	$params,
        	"Cannot login to " . $seafileURL,
        	""
    	    );
	    return "Login to ".$params['serverhostname']." Host failed.\n";
	}
	if ($seafileAPI->enableUser($params['username']) != true) {
	    logModuleCall(
    		'seafile',
    		__FUNCTION__,
    		$params,
    		"Cannot enable/unsuspend user aaccount " . $params['username'] . "Unknown error",    	    
    		""
    	    );
	    return "Error while unsuspend Account: " . $params['username'];
	} else {
	    logModuleCall(
    		'seafile',
    		__FUNCTION__,
    		$params,
    		"Enabled/unsuspended user aaccount " . $params['username'],
    		""
    	    );
	    return 'success';
	} */
}



function zimbraSingle_TerminateAccount($params) {
/*	$seafileURL   = zimbraSingleBuildURL($params);
	$apiuser      = getSeafileAdminUser($params);
	$apipass      = getSeafileAdminPassword($params);

	$seafileAPI = new SeafileAPI($seafileURL,$apiuser,$apipass);
	if ($seafileAPI->login() != true) {
	    return "Login to ".$params['serverhostname']." Host failed.\n";
	}
	
	$result = $seafileAPI->removeUser($params['username']);
	if($result != true) {
	    logModuleCall(
    		'seafile',
    		__FUNCTION__,
    		$params,
    		"Cannot terminate user aaccount " . $params['username'] . "Unknown error",    	    
    		""
    	    );
	    return "Error while deleting user " . $params['username'];
	}
	logModuleCall(
    		'seafile',
    		__FUNCTION__,
    		$params,
    		"Terminated user aaccount " . $params['username'],
    		""
    	);
	return 'success'; */
}

function zimbraSingle_genUsername($name) {
/*    $namelen = strlen($name);
    $result = select_query("tblhosting","COUNT(*)",array("username" => $name));
    $data = mysql_fetch_array($result);
    $username_exists = $data[0];
    $suffix=0;

    while ($username_exists > 0) {
        $suffix++;
    	$name = substr($name,0,$namelen).$suffix;

    	$result = select_query( "tblhosting", "COUNT(*)", array( "username" => $name ) );
    	$data = mysql_fetch_array($result);

    	$username_exists = $data[0];
    }

    return $name; */
}


function zimbraSingle_checkPassword($pwd) {
/*    if (strlen($pwd) < 9) {
        return "Das das Passwort ist zu kurz. Es werden mind. 9 Zeichen benötigt";
    }

    if (!preg_match("#[0-9]+#", $pwd)) {
        return "Das Passwort muss mindestens eine Zahl enthalten";
    }

    if (!preg_match("#[A-Z]+#", $pwd)) {
        return "Das Passwort muss mindestens einen Grossbuchstaben (A-Z) enthalten";
    }     

    if (!preg_match("#[a-z]+#", $pwd)) {
        return "Das Passwort muss mindestens einen Kleinbuchstaben (a-z) enthalten";
    }     

    if (!preg_match("#[^\w]+#", $pwd)) {
        return "Das Passwort muss mindestens ein Sonderzeichen (.,-:=) enthalten";
    }
    return null; */
}

function zimbraSingle_getCustomFieldIDFor($params,$fieldName) {
	$Client = Client::find($params['userid']);
	$clientFields = $Client->customFieldValues;
	
	foreach($Client->services as $service) {
	    //print "ServiceID: " . $service->id . " ?= " . $params['serviceid'] . " <br />";
	    // print nl2br(print_r($service,true));
	    if ($service->packageid == $params['packageid']) {
	        //print " => PackageID found <br />";
        	$serviceFields = $service->customFieldValues;
        	//print nl2br(print_r($serviceFields,true));
        	foreach($serviceFields as $field) {
        	    //print " ===> " . $field->customField->fieldName . " : " . $field->id . "</br />";
        	    //print "    Field: " . $field->customField->fieldName . " ?= Search Field Name: " . $fieldName . " ? " . strcmp($field->customField->fieldName,$fieldName) . " : " . $field->id . " : " . $field->fieldid . "<br />";
    		    if (strcmp($field->customField->fieldName,$fieldName) == 0) {
    			return $field->id;
    		    }
        	}
	    
	    }
	}
	return -1;
	
	
	/*
	**** TESTING METHODS ****
	Please do not remove this lines
	
	 // run through customfields
	foreach($clientFields AS $field){
	      $HTML .= "Field ".$field->customField->fieldName.": ".$field->value."<br>";
	}
	return "";
	
	$HTML .= "Service custom fields";
        foreach($Client->services as $service) {
    	    $HTML .= "----------------------------------------------------------<br />";
    	    $HTML .= nl2br(print_r($service,true));
    	    $HTML .= "----------------------------------------------------------<br />";
            $ServiceFields = $service->customFieldValues;
            foreach($ServiceFields as $field) {
		//$HTML .= "Service field ".$field->customField->fieldName . ": ".$field->value."<br>";
		//$HTML .= "----------------------------------------------------------<br />";
		//$HTML .= nl2br(print_r($field,true));
		//$HTML .= "Service field ".$field->customField->fieldName . "( FieldID: " . $field->fieldid . "/ ID: " . $field->id . "/ RelID:" . $field->relid . ") : " . $field->value . "<br>";
		//$HTML .= "----------------------------------------------------------<br />";
	    }
	}
	*/
}



?>

